#Requires -RunAsAdministrator
# Skrypt PowerShell do wlaczenia TLS 1.2 w Windows 7

Write-Host "============================================" -ForegroundColor Green
Write-Host "  Wlaczanie TLS 1.2 dla Windows 7" -ForegroundColor Green
Write-Host "============================================" -ForegroundColor Green
Write-Host ""

try {
    # TLS 1.2 Client
    $basePath = "HKLM:\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\TLS 1.2\Client"
    New-Item -Path $basePath -Force | Out-Null
    Set-ItemProperty -Path $basePath -Name "Enabled" -Value 1 -Type DWord
    Set-ItemProperty -Path $basePath -Name "DisabledByDefault" -Value 0 -Type DWord
    Write-Host "[OK] TLS 1.2 Client" -ForegroundColor Green

    # TLS 1.2 Server
    $basePath = "HKLM:\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\TLS 1.2\Server"
    New-Item -Path $basePath -Force | Out-Null
    Set-ItemProperty -Path $basePath -Name "Enabled" -Value 1 -Type DWord
    Set-ItemProperty -Path $basePath -Name "DisabledByDefault" -Value 0 -Type DWord
    Write-Host "[OK] TLS 1.2 Server" -ForegroundColor Green

    # WinHTTP
    $winHttpPath = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\WinHttp"
    New-Item -Path $winHttpPath -Force | Out-Null
    Set-ItemProperty -Path $winHttpPath -Name "DefaultSecureProtocols" -Value 2048 -Type DWord
    Write-Host "[OK] WinHTTP" -ForegroundColor Green

    # WinHTTP 32-bit (Wow6432Node)
    $winHttpPath32 = "HKLM:\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Internet Settings\WinHttp"
    if (Test-Path "HKLM:\SOFTWARE\Wow6432Node") {
        New-Item -Path $winHttpPath32 -Force | Out-Null
        Set-ItemProperty -Path $winHttpPath32 -Name "DefaultSecureProtocols" -Value 2048 -Type DWord
        Write-Host "[OK] WinHTTP 32-bit" -ForegroundColor Green
    }

    # Internet Settings
    Set-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" -Name "SecureProtocols" -Value 2048 -Type DWord
    Write-Host "[OK] Internet Settings" -ForegroundColor Green

    Write-Host ""
    Write-Host "============================================" -ForegroundColor Green
    Write-Host "  TLS 1.2 zostalo wlaczone!" -ForegroundColor Green
    Write-Host "============================================" -ForegroundColor Green
    Write-Host ""
    Write-Host "WAZNE: Uruchom ponownie komputer!" -ForegroundColor Yellow
    Write-Host ""

    $restart = Read-Host "Czy zrestartowac teraz? (T/N)"
    if ($restart -eq "T" -or $restart -eq "t") {
        Restart-Computer -Force
    }
}
catch {
    Write-Host "BLAD: $_" -ForegroundColor Red
}

Read-Host "Nacisnij Enter aby zamknac"
