@echo off
title Wlaczanie TLS 1.2 dla Windows 7
color 0A

echo ============================================
echo   Wlaczanie TLS 1.2 dla Windows 7
echo   Wymagane uprawnienia Administratora
echo ============================================
echo.

:: Sprawdz uprawnienia administratora
net session >nul 2>&1
if %errorLevel% neq 0 (
    color 0C
    echo BLAD: Uruchom jako Administrator!
    echo.
    echo Kliknij prawym przyciskiem myszy na plik
    echo i wybierz "Uruchom jako administrator"
    echo.
    pause
    exit /b 1
)

echo Tworzenie kluczy rejestru...
echo.

:: TLS 1.2 Client
reg add "HKLM\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\TLS 1.2\Client" /v "Enabled" /t REG_DWORD /d 1 /f
reg add "HKLM\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\TLS 1.2\Client" /v "DisabledByDefault" /t REG_DWORD /d 0 /f

:: TLS 1.2 Server
reg add "HKLM\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\TLS 1.2\Server" /v "Enabled" /t REG_DWORD /d 1 /f
reg add "HKLM\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\TLS 1.2\Server" /v "DisabledByDefault" /t REG_DWORD /d 0 /f

:: WinHTTP DefaultSecureProtocols (0x800 = TLS 1.2)
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\WinHttp" /v "DefaultSecureProtocols" /t REG_DWORD /d 2048 /f

:: Dla aplikacji 32-bit na 64-bit Windows
reg add "HKLM\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Internet Settings\WinHttp" /v "DefaultSecureProtocols" /t REG_DWORD /d 2048 /f 2>nul

:: Internet Explorer / .NET
reg add "HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" /v "SecureProtocols" /t REG_DWORD /d 2048 /f

echo.
echo ============================================
echo   TLS 1.2 zostalo wlaczone!
echo ============================================
echo.
echo WAZNE: Uruchom ponownie komputer,
echo        aby zmiany zaczely dzialac.
echo.

choice /C TN /M "Czy chcesz teraz zrestartowac komputer? (T=Tak, N=Nie)"
if %errorLevel% equ 1 (
    shutdown /r /t 10 /c "Restart w celu zastosowania TLS 1.2"
    echo Komputer zostanie zrestartowany za 10 sekund...
)

pause
